#include	<htc.h>

/*
 *	Example code for using timer0 on a 16F84
 *	Just sets up a 1 second interrupt and increments a variable
 */

/*
 *	Calculate preload value for one second timer
 */

#define	PERIOD	1000000		// period in uS - one second here
#define	XTAL	4000000		// crystal frequency - 4MHz

#define IPERIOD	(4 * 1000000 / XTAL)	// Period of instruction clock in uSeconds

#define	SCALE	256		// Timer 0 prescaler
#define T0_TICKS 256	// Number of counts for interrupt

#define TICK_PERIOD (SCALE * IPERIOD)	// Period (uSec) of one increment of timer 0

#define	RELOADS	((PERIOD/T0_TICKS)/TICK_PERIOD)

unsigned long	seconds;	// second count
near char reload = 0;

/* service routine for timer 0 interrupt */
void interrupt
timer0_isr(void)
{


	T0IF = 0;
}

void timer0_init(void)
{
	// initialize timer 0; 
	
	OPTION = 0b0111;	// prescale by 256
	T0CS = 0;			// select internal clock
	T0IE = 1;			// enable timer interrupt
	GIE = 1;			// enable global interrupts
}
