// FTDI Code

#include "stdafx.h"
#include "ftdi_class.h"

///////////////////////////////////////////////////////////////////////
//  Function:   GetFTDIRegistryKeys(HKEY hKey)
//   Visibility:   Private
//   Notes:      
///////////////////////////////////////////////////////////////////////

void ftdi_class::GetFTDIRegistryKeys(HKEY hKey)
{
	TCHAR    achKey[MAX_KEY_LENGTH];   // buffer for subkey name
	DWORD    cbName;                   // size of name string 
	TCHAR    achClass[MAX_PATH] = TEXT("");  // buffer for class name 
	DWORD    cchClassName = MAX_PATH;  // size of class string 
	DWORD    cSubKeys=0;               // number of subkeys 
	DWORD    cbMaxSubKey;              // longest subkey size 
	DWORD    cchMaxClass;              // longest class string 
	DWORD    cValues;              // number of values for key 
	DWORD    cchMaxValue;          // longest value name 
	DWORD    cbMaxValueData;       // longest value data 
	DWORD    cbSecurityDescriptor; // size of security descriptor 
	FILETIME ftLastWriteTime;      // last write time 

	DWORD i, retCode; 

	// DWORD cchValue = MAX_VALUE_NAME; 

	// Get the class name and the value count. 
	retCode = RegQueryInfoKey(
		hKey,                    // key handle 
		achClass,                // buffer for class name 
		&cchClassName,           // size of class string 
		NULL,                    // reserved 
		&cSubKeys,               // number of subkeys 
		&cbMaxSubKey,            // longest subkey size 
		&cchMaxClass,            // longest class string 
		&cValues,                // number of values for this key 
		&cchMaxValue,            // longest value name 
		&cbMaxValueData,         // longest value data 
		&cbSecurityDescriptor,   // security descriptor 
		&ftLastWriteTime);       // last write time 

	// Enumerate the subkeys, until RegEnumKeyEx fails./
	//   FILE *outfile;
	//   CString filename = AppDirectory + "keys.txt";
	//   outfile = fopen(filename, "w+");

	if (cSubKeys)
	{
		// fprintf(outfile, "\nNumber of subkeys: %d\n", cSubKeys);

		NumPorts = 0;

		for (i=0; i<cSubKeys; i++) 
		{ 
			cbName = MAX_KEY_LENGTH;
			retCode = RegEnumKeyEx(hKey, i,
				achKey, 
				&cbName, 
				NULL, 
				NULL, 
				NULL, 
				&ftLastWriteTime); 
			if (retCode == ERROR_SUCCESS) 
			{
				//0000\Device Parameters\PortName

				HKEY hTestKey;
				CString key;
				key.Format("SYSTEM\\CurrentControlSet\\Enum\\FTDIBUS\\%s\\0000\\Device Parameters", achKey);

				//  fprintf(outfile, TEXT("(%d) %s\n"), i+1, achKey);
				//  fprintf(outfile, "%s\n", (LPCSTR)key);
				if( RegOpenKeyEx( HKEY_LOCAL_MACHINE,
					// TEXT("SOFTWARE\\Microsoft"),
					(LPCSTR)key,
					0,
					KEY_READ,
					&hTestKey) == ERROR_SUCCESS
					)
				{
					GetFTDIPorts(hTestKey);
				}
			}
		}
	} 
	//   fclose(outfile);
}

///////////////////////////////////////////////////////////////////////
//  Function:   GetFTDIPorts(HKEY hKey)
//   Visibility:   Private
//   Notes:      
///////////////////////////////////////////////////////////////////////

void ftdi_class::GetFTDIPorts(HKEY hKey)
{
	TCHAR    achClass[MAX_PATH] = TEXT("");  // buffer for class name 
	DWORD    cchClassName = MAX_PATH;  // size of class string 
	DWORD    cSubKeys=0;               // number of subkeys 
	DWORD    cbMaxSubKey;              // longest subkey size 
	DWORD    cchMaxClass;              // longest class string 
	DWORD    cValues;              // number of values for key 
	DWORD    cchMaxValue;          // longest value name 
	DWORD    cbMaxValueData;       // longest value data 
	DWORD    cbSecurityDescriptor; // size of security descriptor 
	FILETIME ftLastWriteTime;      // last write time 

	DWORD i, retCode; 

	TCHAR  achValue[MAX_VALUE_NAME]; 
	DWORD cchValue = MAX_VALUE_NAME; 

	// Get the class name and the value count. 
	retCode = RegQueryInfoKey(
		hKey,                    // key handle 
		achClass,                // buffer for class name 
		&cchClassName,           // size of class string 
		NULL,                    // reserved 
		&cSubKeys,               // number of subkeys 
		&cbMaxSubKey,            // longest subkey size 
		&cchMaxClass,            // longest class string 
		&cValues,                // number of values for this key 
		&cchMaxValue,            // longest value name 
		&cbMaxValueData,         // longest value data 
		&cbSecurityDescriptor,   // security descriptor 
		&ftLastWriteTime);       // last write time 

	// Enumerate the subkeys, until RegEnumKeyEx fails.
	//   FILE *outfile;
	//   outfile = fopen("ports.txt", "w+");

	if (cValues) 
	{
		//        fprintf(outfile, "\nNumber of values: %d\n", cValues);

		for (i=0, retCode=ERROR_SUCCESS; i<cValues; i++) 
		{ 
			cchValue = MAX_VALUE_NAME; 
			achValue[0] = '\0'; 
			retCode = RegEnumValue(hKey, i, 
				achValue, 
				&cchValue, 
				NULL, 
				NULL,
				NULL,
				NULL);

			if (retCode == ERROR_SUCCESS ) 
			{ 
				CString name = "PortName";
				DWORD size = 10; //should be the size of the data string //fixed 6/13/06
				unsigned char data[10];
				if(name.Compare((LPCSTR)achValue) == 0)
				{
					long error = RegQueryValueEx(hKey, (LPCSTR)name, NULL, NULL, (LPBYTE)&data, &size);

					if(error == ERROR_SUCCESS)
					{
						// Add the com port to the list of available ports
						int intcomvalue;   //the com port as a number
						sscanf_s((char *)data, "COM%d", &intcomvalue, sizeof(data) );
						ComNumbers[NumPorts] = intcomvalue;
						NumPorts++;
					}
				}
			} 
		}
	}
}

///////////////////////////////////////////////////////////////////////
//  Function:   RetrievePortsFromRegistry()
//   Visibility:   Private
//   Notes:      
///////////////////////////////////////////////////////////////////////

void ftdi_class::RetrievePortsFromRegistry()
{
	HKEY hTestKey;

	if( RegOpenKeyEx( HKEY_LOCAL_MACHINE,
		TEXT("SYSTEM\\CurrentControlSet\\Enum\\FTDIBUS"),
		0,
		KEY_READ,
		&hTestKey) == ERROR_SUCCESS
		)
	{
		GetFTDIRegistryKeys(hTestKey);
	}
	else
	{
		Error = "No USB drivers have been installed on this system.";
	}
}


void ftdi_class::EnumCommNames(EnumCommProc fnCatch, void* pArg)
{
	HKEY hkCommMap;
	if (ERROR_SUCCESS != RegOpenKeyEx(
		HKEY_LOCAL_MACHINE,
		TEXT("HARDWARE\\DEVICEMAP\\SERIALCOMM"),
		0,
		KEY_QUERY_VALUE,
		&hkCommMap))
	{
		TRACE0(
			"Failed to open 'HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM' "
			"registry key\n");
		return;
	}
	void* pValNameBuff = 0;
	void* pValueBuff = 0;
	__try
	{
		DWORD dwValCount, dwMaxCharValNameLen, dwMaxWideValueSize;
		if (ERROR_SUCCESS != RegQueryInfoKey(
			hkCommMap,
			NULL, NULL, NULL, NULL, NULL, NULL,
			&dwValCount,
			&dwMaxCharValNameLen,
			&dwMaxWideValueSize,
			NULL, NULL))
		{
			TRACE0(
				"Failed to query info for the "
				"'HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM' registry key\n");
			__leave;
		}
		// The max value name size is returned in TCHARs not including
		// the terminating null character.
		const DWORD dwMaxCharValNameSize = dwMaxCharValNameLen + 1;
		pValNameBuff = malloc(dwMaxCharValNameSize*(sizeof (TCHAR)));
		if (!pValNameBuff)
		{
			TRACE0(
				"Failed to allocate memory for enumerating registry value "
				"names\n");
			__leave;
		}
		// The max value size is returned in bytes needed to hold the UNICODE
		// strings including terminating null character regardless of the
		// function type (ANSI or UNICODE).
		const DWORD dwMaxByteValueSize = (dwMaxWideValueSize/2)*(sizeof (TCHAR));
		pValueBuff = malloc(dwMaxByteValueSize);
		if (!pValueBuff)
		{
			TRACE0(
				"Failed to allocate memory for enumerating registry "
				"values\n");
			__leave;
		}
		for (DWORD dwIndex = 0; dwIndex < dwValCount; ++dwIndex)
		{
			DWORD dwCharValNameSize = dwMaxCharValNameSize;
			DWORD dwByteValueSize = dwMaxByteValueSize;
			DWORD dwType;
			LONG nRes = RegEnumValue(
				hkCommMap,
				dwIndex,
				(LPTSTR)pValNameBuff,
				&dwCharValNameSize,
				NULL,
				&dwType,
				(LPBYTE)pValueBuff,
				&dwByteValueSize);
			if (nRes != ERROR_SUCCESS)
			{
				TRACE2("Failed to enum value, error %lu(%08lXh)\n",
					(ULONG)nRes,
					(ULONG)nRes);
				break;
			}
			ASSERT((ULONG)dwCharValNameSize
				== (ULONG)lstrlen((LPCTSTR)pValNameBuff));
			if (dwType != REG_SZ)
			{
				TRACE1(
					"Unexpected value type (%lu) while enumerating the "
					"'HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM' registry key\n",
					(ULONG)dwType);
				continue;
			}
			ASSERT((ULONG)(dwByteValueSize/(sizeof (TCHAR)))
				== (ULONG)(lstrlen((LPCTSTR)pValueBuff) + 1));

			// Save the COM Number
			ActiveComPorts[m_numPorts++] = atoi( &((LPCTSTR)pValueBuff)[3] );

			// csListComms[m_numPorts++] = (LPCTSTR)pValueBuff;
		}
	}
	__finally
	{
		free(pValueBuff);
		free(pValNameBuff);
		VERIFY(RegCloseKey(hkCommMap) == ERROR_SUCCESS);
	}
}


// Is this FTDI port an active com port?
int ftdi_class::ActivePort(int port)
{
	for (int i=0; i<m_numPorts; i++)
	{
		if (ActiveComPorts[i] == port)
			return TRUE;
	}

	return FALSE;
}