// SerialScriptDlg.h : header file
//

#include "afxwin.h"
#include "afxcmn.h"
#pragma warning(disable:4146)
#include "file_status.h"
#include <iostream>
#include <fstream>
#include <string>
#include <stdio.h>
#include <stdlib.h>

#if !defined(__SERIALSCRIPTDLG_H__)
#define __SERIALSCRIPTDLG_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CSerialScriptDlg dialog
class SerialThread;
class ScriptThread;

class CSerialScriptDlg : public CDialog
{
// Construction
public:
	CSerialScriptDlg(CWnd* pParent = NULL);	// standard constructor
	~CSerialScriptDlg();

	CString		csCapDir;
	CString		csCapFilename;
	CString		csPort;
	CString		cstrFile;
	CString		cstrFileNew;
	
	void		CloseFiles();
	void		OnComplete();
	void		OnOpenError();
	void		OnProcess( char * inputData, unsigned long lenMessage );
	char		*inputData;
	CString		cnum;
	CString		cname;
	CString		cid;
	CString		csNumber;
	CString		csName;

	FILE *		fdWrite;
	FILE *      fdTrace;

	int			bIsValidFile;

	int			iIsFirstPacket;
	int			iNumProcessPackets;
	long		iNumProcessBytes;

	int			tsChange;
	int			newUnsaved;
	bool		scriptChange;

	CString     m_csComPort[10];

	void		AddToStatusList(LPCTSTR sText);

	CBitmap		m_hFilOpnBmp;
	CButton		m_bFilOpn1;
	CButton		m_bFilOpn2;
	CButton		m_bFilOpn3;
	CButton		m_bFilOpn4;
	CButton		m_bFilOpn5;
	CButton		m_bFilOpn6;
	CButton		m_bFilOpn7;
	CButton		m_bFilOpn8;
	CButton		m_bFilOpn9;
	CButton		m_bFilOpn10;

	CBitmap     m_hScriptBmp;
	CButton		m_bScriptBrowse1;
	CButton		m_bScriptBrowse2;
	CButton		m_bScriptBrowse3;
	CButton		m_bScriptBrowse4;
	CButton		m_bScriptBrowse5;
	CButton		m_bScriptBrowse6;
	CButton		m_bScriptBrowse7;
	CButton		m_bScriptBrowse8;
	CButton		m_bScriptBrowse9;
	CButton		m_bScriptBrowse10;

	CButton		m_btnRestore;
	CButton		m_btnNew;
	CButton		m_btnSave;
	CButton		m_btnDelete;
	CButton		m_btnConfig;
	CButton		m_btnLoadsuite;

// Dialog Data
	//{{AFX_DATA(CSerialScriptDlg)
	enum { IDD = IDD_SERIALSCRIPT_DIALOG };
	CString	m_namePort;
	CString	m_namePort1;
	CString	m_namePort2;
	CString	m_namePort3;
	CString	m_namePort4;
	CString	m_namePort5;
	CString	m_namePort6;
	CString	m_namePort7;
	CString	m_namePort8;
	CString	m_namePort9;
	CString	m_namePort10;

	CString	m_baudRate;
	CString	m_monitorRec;
	CComboBox m_cbNamePort;

	DCB configSerial_;
    bool openPortActivate;
    bool closePortActivate;
	CString	m_status_port;
    SerialThread* serialProcess;
    BOOL activeProccess;
	//}}AFX_DATA

	ScriptThread* scriptProcess;
	BOOL scriptActive;
	CString csHandsetID;

	void ThreadStart( CString csHandsetID, CString m_namePort, CEdit &m_script_name, CEdit &m_delay );

    bool sendActivate;
	bool incomingCall;
	bool incomingCallID;
	CString word1;
	CString word2;
	char sendBuffer[1024];
	long sendLength;

	void SendString( char *strSend );
	int  bInFileTransfer;

	void LogBegin();
	void Log( CString strMessage );  
	CString logFile;
	int  newLogFile;
	int	 stopLog;
	int  runTime;
	int logStartup;
	CString  handSet;
	CString cstrFilePath;

	void ScriptFileCheck(CString csScript);
	bool scriptFileOpens;
	CString failingScriptFile;

	CString DTMF[10]; // dial code must be a fixed number for each handset

// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSerialScriptDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	
	// Implementation
	protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSerialScriptDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnOpenPort();
	afx_msg void OnClosePort();
	afx_msg void OnSendData();
	//}}AFX_MSG
	virtual void OnCancel();
	DECLARE_MESSAGE_MAP()
private:
	void UpdateConfig();
	void SendACK();
	void SendNAK();
	BOOL FileExists(LPCSTR szFile);

public:
	afx_msg void OnBnClickedStreamData();
	afx_msg void OnBnClickedChange();
	CStatic m_stPathName;
	CStatic m_stFileName;
	CEdit m_delay;
	CEdit m_delay1;
	CEdit m_delay2;
	CEdit m_delay3;
	CEdit m_delay4;
	CEdit m_delay5;
	CEdit m_delay6;
	CEdit m_delay7;
	CEdit m_delay8;
	CEdit m_delay9;
	CEdit m_delay10;
	CEdit m_script_name;
	CEdit m_script_name1;
	CEdit m_script_name2;
	CEdit m_script_name3;
	CEdit m_script_name4;
	CEdit m_script_name5;
	CEdit m_script_name6;
	CEdit m_script_name7;
	CEdit m_script_name8;
	CEdit m_script_name9;
	CEdit m_script_name10;
	CEdit m_script_suite;

	void  OnGetScript( CEdit &m_script_name );
	void  ViewScript(CEdit &m_script_name);
	void  SetHandsetSettings();	
	CString csScript;
	void  GetSetSuiteSettings(CString cstrHSsettingsPath, CEdit &m_script_name, CEdit &m_delay, CButton &m_enable );
	void  HandsetSettingsToXML();
	void  TestSuiteCompare();
	int   CompareAndSave();

	afx_msg void OnSelectScript1();
	afx_msg void OnSelectScript2();
	afx_msg void OnSelectScript3();
	afx_msg void OnSelectScript4();
	afx_msg void OnSelectScript5();
	afx_msg void OnSelectScript6();
	afx_msg void OnSelectScript7();
	afx_msg void OnSelectScript8();
	afx_msg void OnSelectScript9();
	afx_msg void OnSelectScript10();

	afx_msg void OnLoadTestSuite();
	afx_msg void OnBnClickedRestore();	
	afx_msg void OnBnClickedNew();
	afx_msg void OnBnClickedSave();
	afx_msg void OnBnClickedDelete();
	afx_msg void OnBnClickedStart();
	afx_msg void OnBnClickedStop();

	CButton m_enable;
	CButton m_enable1;
	CButton m_enable2;
	CButton m_enable3;
	CButton m_enable4;
	CButton m_enable5;
	CButton m_enable6;
	CButton m_enable7;
	CButton m_enable8;
	CButton m_enable9;
	CButton m_enable10;

	CButton m_btnStart;
	CButton m_btnStop;

	CEdit m_edComment;
	CComboBox m_cbRepeat;
	afx_msg void OnClose();
	afx_msg void OnBnClickedConfig();

	afx_msg void OnBnClickedOpen1();
	afx_msg void OnBnClickedOpen2();
	afx_msg void OnBnClickedOpen3();
	afx_msg void OnBnClickedOpen4();
	afx_msg void OnBnClickedOpen5();
	afx_msg void OnBnClickedOpen6();
	afx_msg void OnBnClickedOpen7();
	afx_msg void OnBnClickedOpen8();
	afx_msg void OnBnClickedOpen9();
	afx_msg void OnBnClickedOpen10();

	CListBox m_lbRcvMsg;
	afx_msg void OnBnClickedRcvclr();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SERIALAPPDLG_H__81B8D820_84F4_495C_A799_9659B5277C70__INCLUDED_)
