// ConfigDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SerialScript.h"
#include "ConfigDlg.h"


// CConfigDlg dialog

IMPLEMENT_DYNAMIC(CConfigDlg, CDialog)

CConfigDlg::CConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDlg::IDD, pParent)
{

}

CConfigDlg::~CConfigDlg()
{
}

void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMPORT1,  m_cbComPort[0] );
	DDX_Control(pDX, IDC_COMPORT2,  m_cbComPort[1] );
	DDX_Control(pDX, IDC_COMPORT3,  m_cbComPort[2] );
	DDX_Control(pDX, IDC_COMPORT4,  m_cbComPort[3] );	
	DDX_Control(pDX, IDC_COMPORT5,  m_cbComPort[4] );
	DDX_Control(pDX, IDC_COMPORT6,  m_cbComPort[5] );	
	DDX_Control(pDX, IDC_COMPORT7,  m_cbComPort[6] );
	DDX_Control(pDX, IDC_COMPORT8,  m_cbComPort[7] );	
	DDX_Control(pDX, IDC_COMPORT9,  m_cbComPort[8] );
	DDX_Control(pDX, IDC_COMPORT10, m_cbComPort[9] );
}


BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CConfigDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CConfigDlg message handlers

BOOL CConfigDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add a bunch to make sure it works nicely
	m_numPorts=0;
	EnumCommNames(NULL,NULL);  // sets number of ports and list (csListComms)

	// Now sort the data
	CString strIni, strInj;
	CString tmp;
	int     iStrI, iStrJ;

	// Now sort the data
	for (int i=0; i<m_numPorts-1; i++)
	{
		// Everything except COM
		strIni = csListComms[i].Right( csListComms[i].GetLength()-3 );
		iStrI  = atoi(strIni);

		for (int j=i+1; j<m_numPorts; j++)
		{
			// Everything except COM
			strInj = csListComms[j].Right( csListComms[j].GetLength()-3 );
			iStrJ  = atoi(strInj);
			if (iStrJ < iStrI) // adjust the COM list to ascending order
			{	
				tmp = csListComms[i];
				csListComms[i] = csListComms[j];
				csListComms[j] = tmp;

				strIni = csListComms[i].Right( csListComms[i].GetLength()-3 );
				iStrI  = atoi(strIni);
			}
		}
	}

    // Search for an exact match!
	for (int i=0; i<10; i++)
		OnPushCom( m_cbComPort[i], m_csComPort[i] );

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CConfigDlg::OnPushCom( CComboBox &cbPorts, CString csComChoice )
{
	cbPorts.ResetContent();
	cbPorts.AddString( "-" );
	cbPorts.SetCurSel(0);

	// Next Step
    for( char port=0; port<m_numPorts; port++)
    {
		cbPorts.AddString(csListComms[port]);
	}

   // Search for an exact match!
	cbPorts.SetCurSel(0);
    for( int port=0; port<m_numPorts; port++)
	{
		char strPortNameStr[256];
		cbPorts.GetLBText(port,strPortNameStr);
		if ( (strlen(strPortNameStr)==strlen(csComChoice)) &&
			 (!strcmp(strPortNameStr,csComChoice) )
		   )
		{
			cbPorts.SetCurSel(port);
		}
	}
}


void CConfigDlg::OnBnClickedOk()
{
	CString strSelected;

	for (int i=0; i<10; i++)
	{
		int index = m_cbComPort[i].GetCurSel();
		if( index != CB_ERR )
		{
			m_cbComPort[i].GetLBText(index, m_csComPort[i]);
		}
	}


	// This is a check to catch any duplicate ports
	int bFailCompare = false;
	for (int i=0; i<10; i++)
	{
		for (int j=i+1; j<10; j++)
		{
			// Check for any duplicates
			if ((m_csComPort[i] == m_csComPort[j]) && (m_csComPort[i] != "-") )
			{
				CString csFailMessage;
				csFailMessage.Format( "Setup %d and Setup %d cannot share the same COM port [%s]",
					i+1, j+1, m_csComPort[i] );
				AfxMessageBox( csFailMessage, MB_OK );
				bFailCompare = true;

				m_cbComPort[j].SetCurSel(0);
			}
		}
	}

	// TODO: Add your control notification handler code here
	if (!bFailCompare)
		OnOK();
}

/**
 * Sometimes it is possibly to use a code like this.
 * If you are not using MFC, include windows.h and ensure
 * ASSERT(), VERIFY() and TRACEx() macros are defined.
 */




void CConfigDlg::EnumCommNames(EnumCommProc fnCatch, void* pArg)
{
	HKEY hkCommMap;
	if (ERROR_SUCCESS != RegOpenKeyEx(
		HKEY_LOCAL_MACHINE,
		TEXT("HARDWARE\\DEVICEMAP\\SERIALCOMM"),
		0,
		KEY_QUERY_VALUE,
		&hkCommMap))
	{
		TRACE0(
			"Failed to open 'HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM' "
			"registry key\n");
		return;
	}
	void* pValNameBuff = 0;
	void* pValueBuff = 0;
	__try
	{
		DWORD dwValCount, dwMaxCharValNameLen, dwMaxWideValueSize;
		if (ERROR_SUCCESS != RegQueryInfoKey(
			hkCommMap,
			NULL, NULL, NULL, NULL, NULL, NULL,
			&dwValCount,
			&dwMaxCharValNameLen,
			&dwMaxWideValueSize,
			NULL, NULL))
		{
			TRACE0(
				"Failed to query info for the "
				"'HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM' registry key\n");
			__leave;
		}
		// The max value name size is returned in TCHARs not including
		// the terminating null character.
		const int dwMaxCharValNameSize = dwMaxCharValNameLen + 1;
		pValNameBuff = malloc(dwMaxCharValNameSize*(sizeof (TCHAR)));
		if (!pValNameBuff)
		{
			TRACE0(
				"Failed to allocate memory for enumerating registry value "
				"names\n");
			__leave;
		}
		// The max value size is returned in bytes needed to hold the UNICODE
		// strings including terminating null character regardless of the
		// function type (ANSI or UNICODE).
		const int dwMaxByteValueSize = (dwMaxWideValueSize/2)*(sizeof (TCHAR));
		pValueBuff = malloc(dwMaxByteValueSize);
		if (!pValueBuff)
		{
			TRACE0(
				"Failed to allocate memory for enumerating registry "
				"values\n");
			__leave;
		}
		for (DWORD dwIndex = 0; dwIndex < dwValCount; ++dwIndex)
		{
			DWORD dwCharValNameSize = dwMaxCharValNameSize;
			DWORD dwByteValueSize = dwMaxByteValueSize;
			DWORD dwType;
			LONG nRes = RegEnumValue(
				hkCommMap,
				dwIndex,
				(LPTSTR)pValNameBuff,
				&dwCharValNameSize,
				NULL,
				&dwType,
				(LPBYTE)pValueBuff,
				&dwByteValueSize);
			if (nRes != ERROR_SUCCESS)
			{
				TRACE2("Failed to enum value, error %lu(%08lXh)\n",
					(ULONG)nRes,
					(ULONG)nRes);
				break;
			}
			ASSERT((ULONG)dwCharValNameSize
				== (ULONG)lstrlen((LPCTSTR)pValNameBuff));
			if (dwType != REG_SZ)
			{
				TRACE1(
					"Unexpected value type (%lu) while enumerating the "
					"'HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM' registry key\n",
					(ULONG)dwType);
				continue;
			}
			ASSERT((ULONG)(dwByteValueSize/(sizeof (TCHAR)))
				== (ULONG)(lstrlen((LPCTSTR)pValueBuff) + 1));

			csListComms[m_numPorts++] = (LPCTSTR)pValueBuff;
			// LogInfo("%s\r\n",pValueBuff);
		}
	}
	__finally
	{
		free(pValueBuff);
		free(pValNameBuff);
		VERIFY(RegCloseKey(hkCommMap) == ERROR_SUCCESS);
	}

}
