/********************************************************************
created:	2009/12/08
file path:	C:\SerialScript\SerialScript\
file base:	serialThread
file ext:	cpp
author:		PacificWare, Inc.

purpose:	This class is used to handle the threads of serial communcation.
*********************************************************************/

#include "stdafx.h"
#include "serialCtl.h"
#include "resource.h"
#include "SerialScriptDlg.h"
#include "serialThread.h"

const unsigned short MAX_MESSAGE = 100;

IMPLEMENT_DYNCREATE(SerialThread,CWinThread)
//SerialThread::SerialThread()
//----------------------------------------------------------------------------
//Constructor
//
SerialThread::SerialThread()
:ptrDlg(NULL)
{
}

//SerialThread::~SerialThread()
//----------------------------------------------------------------------------
//Deconstructor
//
SerialThread::~SerialThread()
{
	ptrDlg = NULL;
}

//SerialThread::InitInstance()
//----------------------------------------------------------------------------
//Deconstructor
//
BOOL
SerialThread::InitInstance()
{
	return TRUE;
}

// SerialThread::Run()
//----------------------------------------------------------------------------
// Description: This is a virtual function that is called when thread process
//               is created to be one task.
//
int
SerialThread::Run()
{
	// Check signal controlling and status to open serial communication.
	while(1)
	{
		// Start process of serial communication operation.
		while(ptrDlg->activeProccess == TRUE)
		{
			// enter if there is command of opening and port has to be closed before.
			if ((SCC::serialCtl().getStatusPort() == FALSE) && 
				ptrDlg->openPortActivate)
			{
				// open port by calling api function of class serialCtl.
				if (SCC::serialCtl().openPort(ptrDlg->configSerial_,
					ptrDlg->m_namePort) == TRUE)
				{
					// Indicate message to status moditor that commnication connected already.
					// ptrDlg->SetDlgItemText(IDC_STATUS_PORT,"Connected");
				}
				else
				{
					// Have problem since opening serial communication.
					ptrDlg->OnOpenError();
					ptrDlg->activeProccess = FALSE;
				}
			}
			else if (ptrDlg->openPortActivate)
			{
				char mess[MAX_MESSAGE];
				unsigned int lenBuff = MAX_MESSAGE;
				unsigned long lenMessage;
				if (SCC::serialCtl().read_scc(mess,lenBuff,lenMessage) == TRUE)
				{	// send received message 
					ptrDlg->OnProcess(mess, lenMessage);
				}
				else
				{
					ptrDlg->activeProccess = FALSE;
				}
			}

			// Check signal controlling to send data.
			if (ptrDlg->sendActivate && (ptrDlg->sendLength > 0))
			{
				unsigned long len;
				SCC::serialCtl().write_scc(ptrDlg->sendBuffer,
					ptrDlg->sendLength,len);
				ptrDlg->sendActivate = false;
			}

			// Check status and signal controlling to close serial communication.
			if (ptrDlg->closePortActivate)
			{
				if (SCC::serialCtl().closePort() == TRUE)
				{
					// Show message that close when performming of closing port okay.
					ptrDlg->closePortActivate = false;
				}
			}
		}
	}
	return 0;
}

