/////////////////////////////////////////////////////////////////
//	cart_class.h
//
//	This file is the definition file for the cart class
//	which communicates over the serial port with the cart
//  controller board developed by D2M.
//
//	Author:  Dan Jones
//	Written: 9-25-05
//
/////////////////////////////////////////////////////////////////
#ifndef _FTDICLASS_H_
#define _FTDICLASS_H_

#define MAX_PORTS	255

#define MAX_KEY_LENGTH 255
#define MAX_VALUE_NAME 16383


#include <windows.h>
#include <stdio.h>
#include <tchar.h>

typedef bool (*EnumCommProc)(LPCTSTR lpszComm, void* pArg);

class	ftdi_class
{
private:
	void	GetFTDIPorts(HKEY hKey);
	void	GetFTDIRegistryKeys(HKEY hKey);

	CString Error;

public:
	void	RetrievePortsFromRegistry();	//used in the thread
	int		NumPorts;
	int		ComNumbers[256]; //Max serial ports
	void	EnumCommNames(EnumCommProc fnCatch, void* pArg);
	int     ActivePort(int port);

	// CString csListComms[256];
	int		ActiveComPorts[256]; //Max serial ports
	int		m_numPorts;
};

extern ftdi_class	cart;


#endif
