// SerialScriptDlg.cpp : implementation file
//

#include "stdafx.h"
#include "serialCtl.h"
#include "serialThread.h"
#include "SerialScript.h"
#include "SerialScriptDlg.h"
#include "About.h"
#include "NewSuiteDlg.h"

#include "ScriptThread.h"

#include "mmsystem.h"
#include "ftdi_class.h"

#include "XMLSettings.h"
#include "ConfigDlg.h"

#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char strFilePath[512];

#define XML_STRING_BASE			"SerialScript\\Settings"
#define XML_STRING_HANDSET1		XML_STRING_BASE"\\setup1"
#define XML_STRING_HANDSET2 	XML_STRING_BASE"\\setup2"
#define XML_STRING_HANDSET3 	XML_STRING_BASE"\\setup3"
#define XML_STRING_HANDSET4 	XML_STRING_BASE"\\setup4"
#define XML_STRING_HANDSET5 	XML_STRING_BASE"\\setup5"
#define XML_STRING_HANDSET6 	XML_STRING_BASE"\\setup6"
#define XML_STRING_HANDSET7 	XML_STRING_BASE"\\setup7"
#define XML_STRING_HANDSET8 	XML_STRING_BASE"\\setup8"
#define XML_STRING_HANDSET9 	XML_STRING_BASE"\\setup9"
#define XML_STRING_HANDSET10	XML_STRING_BASE"\\setup10"

#define XML_STRING_COMMENT		XML_STRING_BASE"\\Comment"
#define XML_STRING_REPEAT		XML_STRING_BASE"\\Repeat"

#define SCP_BASE_PATH			"C:\\SerialScript\\Scripts"
#define LOG_BASE_PATH			"C:\\SerialScript\\Logs"



/////////////////////////////////////////////////////////////////////////////
// CSerialScriptDlg dialog

CSerialScriptDlg::CSerialScriptDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSerialScriptDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSerialScriptDlg)
	//m_namePort = _T("");
	m_baudRate = _T("");
	m_monitorRec = _T("");
	m_status_port = _T("");
	openPortActivate = false;
	closePortActivate = false;
    sendActivate = FALSE;
	incomingCall = FALSE; 
	incomingCallID = FALSE;

	activeProccess = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_baudRate = "115200";
	m_namePort = "COM4";

	bInFileTransfer = false;

	bIsValidFile = true;
}

CString cstrFile = "default.xml";


CSerialScriptDlg::~CSerialScriptDlg()
{
}

void CSerialScriptDlg::DoDataExchange(CDataExchange* pDX)
// sets initial location for the data exchange (delay and script)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSerialScriptDlg)
	//}}AFX_DATA_MAP

	// Save the defaults
	if (pDX->m_bSaveAndValidate)
	{
	}
	DDX_Control(pDX, IDC_DELAY1, m_delay1);
	DDX_Control(pDX, IDC_DELAY2, m_delay2);
	DDX_Control(pDX, IDC_DELAY3, m_delay3);
	DDX_Control(pDX, IDC_DELAY4, m_delay4);
	DDX_Control(pDX, IDC_DELAY5, m_delay5);
	DDX_Control(pDX, IDC_DELAY6, m_delay6);
	DDX_Control(pDX, IDC_DELAY7, m_delay7);
	DDX_Control(pDX, IDC_DELAY8, m_delay8);
	DDX_Control(pDX, IDC_DELAY9, m_delay9);
	DDX_Control(pDX, IDC_DELAY10, m_delay10);
	DDX_Control(pDX, IDC_SCRIPT1, m_script_name1);
	DDX_Control(pDX, IDC_SCRIPT2, m_script_name2); 
	DDX_Control(pDX, IDC_SCRIPT3, m_script_name3);
	DDX_Control(pDX, IDC_SCRIPT4, m_script_name4); 
	DDX_Control(pDX, IDC_SCRIPT5, m_script_name5);
	DDX_Control(pDX, IDC_SCRIPT6, m_script_name6); 
	DDX_Control(pDX, IDC_SCRIPT7, m_script_name7);
	DDX_Control(pDX, IDC_SCRIPT8, m_script_name8); 
	DDX_Control(pDX, IDC_SCRIPT9, m_script_name9);
	DDX_Control(pDX, IDC_SCRIPT10, m_script_name10); 
	DDX_Control(pDX, IDC_ENABLE1, m_enable1);
	DDX_Control(pDX, IDC_ENABLE2, m_enable2);
	DDX_Control(pDX, IDC_ENABLE3, m_enable3);
	DDX_Control(pDX, IDC_ENABLE4, m_enable4);
	DDX_Control(pDX, IDC_ENABLE5, m_enable5);
	DDX_Control(pDX, IDC_ENABLE6, m_enable6);
	DDX_Control(pDX, IDC_ENABLE7, m_enable7);
	DDX_Control(pDX, IDC_ENABLE8, m_enable8);
	DDX_Control(pDX, IDC_ENABLE9, m_enable9);
	DDX_Control(pDX, IDC_ENABLE10, m_enable10);

	DDX_Control(pDX, IDC_SUITE, m_script_suite); 
	DDX_Control(pDX, IDC_COMMENT, m_edComment);
	DDX_Control(pDX, IDC_REPEAT, m_cbRepeat);

	DDX_Control(pDX, IDC_START, m_btnStart);	
	DDX_Control(pDX, IDC_STOP, m_btnStop);	

	DDX_Control(pDX, IDC_RCVMSG, m_lbRcvMsg);
	DDX_Control(pDX, IDC_FILOPN1, m_bFilOpn1);
	DDX_Control(pDX, IDC_FILOPN2, m_bFilOpn2);
	DDX_Control(pDX, IDC_FILOPN3, m_bFilOpn3);
	DDX_Control(pDX, IDC_FILOPN4, m_bFilOpn4);	
	DDX_Control(pDX, IDC_FILOPN5, m_bFilOpn5);
	DDX_Control(pDX, IDC_FILOPN6, m_bFilOpn6);
	DDX_Control(pDX, IDC_FILOPN7, m_bFilOpn7);
	DDX_Control(pDX, IDC_FILOPN8, m_bFilOpn8);
	DDX_Control(pDX, IDC_FILOPN9, m_bFilOpn9);	
	DDX_Control(pDX, IDC_FILOPN10, m_bFilOpn10);

	DDX_Control(pDX, IDC_BROWSE1, m_bScriptBrowse1);
	DDX_Control(pDX, IDC_BROWSE2, m_bScriptBrowse2);
	DDX_Control(pDX, IDC_BROWSE3, m_bScriptBrowse3);
	DDX_Control(pDX, IDC_BROWSE4, m_bScriptBrowse4);
	DDX_Control(pDX, IDC_BROWSE5, m_bScriptBrowse5);
	DDX_Control(pDX, IDC_BROWSE6, m_bScriptBrowse6);
	DDX_Control(pDX, IDC_BROWSE7, m_bScriptBrowse7);
	DDX_Control(pDX, IDC_BROWSE8, m_bScriptBrowse8);
	DDX_Control(pDX, IDC_BROWSE9, m_bScriptBrowse9);
	DDX_Control(pDX, IDC_BROWSE10, m_bScriptBrowse10);

	DDX_Control(pDX, IDC_RESTORE, m_btnRestore);
	DDX_Control(pDX, IDC_NEW, m_btnNew);
	DDX_Control(pDX, IDC_SAVE, m_btnSave);
	DDX_Control(pDX, IDC_DELETE, m_btnDelete);
	DDX_Control(pDX, IDC_CONFIG, m_btnConfig);
	DDX_Control(pDX, IDC_LOADSUITE, m_btnLoadsuite);

}



BEGIN_MESSAGE_MAP(CSerialScriptDlg, CDialog)
	//{{AFX_MSG_MAP(CSerialScriptDlg)
	// Calls the correct data update routine when a button is clicked
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE1, &CSerialScriptDlg::OnSelectScript1)
	ON_BN_CLICKED(IDC_BROWSE2, &CSerialScriptDlg::OnSelectScript2)
	ON_BN_CLICKED(IDC_BROWSE3, &CSerialScriptDlg::OnSelectScript3)
	ON_BN_CLICKED(IDC_BROWSE4, &CSerialScriptDlg::OnSelectScript4)
	ON_BN_CLICKED(IDC_BROWSE5, &CSerialScriptDlg::OnSelectScript5)
	ON_BN_CLICKED(IDC_BROWSE6, &CSerialScriptDlg::OnSelectScript6)
	ON_BN_CLICKED(IDC_BROWSE7, &CSerialScriptDlg::OnSelectScript7)
	ON_BN_CLICKED(IDC_BROWSE8, &CSerialScriptDlg::OnSelectScript8)
	ON_BN_CLICKED(IDC_BROWSE9, &CSerialScriptDlg::OnSelectScript9)
	ON_BN_CLICKED(IDC_BROWSE10, &CSerialScriptDlg::OnSelectScript10)

	ON_BN_CLICKED(IDC_LOADSUITE, &CSerialScriptDlg::OnLoadTestSuite) // Test Scenario
	ON_BN_CLICKED(IDC_RESTORE, &CSerialScriptDlg::OnBnClickedRestore)
	ON_BN_CLICKED(IDC_NEW, &CSerialScriptDlg::OnBnClickedNew)
	ON_BN_CLICKED(IDC_SAVE, &CSerialScriptDlg::OnBnClickedSave)
	ON_BN_CLICKED(IDC_DELETE, &CSerialScriptDlg::OnBnClickedDelete)
	ON_BN_CLICKED(IDC_START, &CSerialScriptDlg::OnBnClickedStart)
	ON_BN_CLICKED(IDC_STOP, &CSerialScriptDlg::OnBnClickedStop)

	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_CONFIG, &CSerialScriptDlg::OnBnClickedConfig)

	ON_BN_CLICKED(IDC_FILOPN1, &CSerialScriptDlg::OnBnClickedOpen1)
	ON_BN_CLICKED(IDC_FILOPN2, &CSerialScriptDlg::OnBnClickedOpen2)
	ON_BN_CLICKED(IDC_FILOPN3, &CSerialScriptDlg::OnBnClickedOpen3)
	ON_BN_CLICKED(IDC_FILOPN4, &CSerialScriptDlg::OnBnClickedOpen4)
	ON_BN_CLICKED(IDC_FILOPN5, &CSerialScriptDlg::OnBnClickedOpen5)
	ON_BN_CLICKED(IDC_FILOPN6, &CSerialScriptDlg::OnBnClickedOpen6)
	ON_BN_CLICKED(IDC_FILOPN7, &CSerialScriptDlg::OnBnClickedOpen7)
	ON_BN_CLICKED(IDC_FILOPN8, &CSerialScriptDlg::OnBnClickedOpen8)
	ON_BN_CLICKED(IDC_FILOPN9, &CSerialScriptDlg::OnBnClickedOpen9)
	ON_BN_CLICKED(IDC_FILOPN10, &CSerialScriptDlg::OnBnClickedOpen10)

	ON_BN_CLICKED(IDC_RCVCLR, &CSerialScriptDlg::OnBnClickedRcvclr)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSerialScriptDlg message handlers

BOOL CSerialScriptDlg::OnInitDialog()
// used during initialization only
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    serialProcess = 
		(SerialThread*)AfxBeginThread(RUNTIME_CLASS(SerialThread), 
		THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED);
		serialProcess->setOwner(this);

  	// EnumCommNames(NULL,NULL);

	fdWrite=NULL;
	fdTrace=NULL;

	ftdi_class fc;

	// opens all of the ports associated with the FDTI chip.
	// if the port is already opened and we are using it, don't bother opening it again
	// if no ports exist, the registry is queried to find more.
	fc.RetrievePortsFromRegistry();
	fc.m_numPorts=0;
	fc.EnumCommNames(NULL,NULL);

	// Initialize windows

	m_script_suite.SetWindowTextA(cstrFile); // Test Scenario

	// A Nice Open file button
#if 0
    m_fgFileStatus.put_Cols(4);
    m_fgFileStatus.put_ColWidth(0,2800); //col width
    m_fgFileStatus.put_ColWidth(1,850); //col width
    m_fgFileStatus.put_ColWidth(2,800); //col width
    m_fgFileStatus.put_ColWidth(3,800); //col width

    m_fgFileStatus.put_Row(0);
    m_fgFileStatus.put_Col(0);
    m_fgFileStatus.put_Text("Filename");
    m_fgFileStatus.put_Col(1);
    m_fgFileStatus.put_Text("Stats");
    m_fgFileStatus.put_Col(2);
    m_fgFileStatus.put_Text("Received");
    m_fgFileStatus.put_Col(3);
    m_fgFileStatus.put_Text("Sent");
#endif


	// read the last script and set up the handset settings
	CString csComment;
	CString csScript;
	CString csDelay;
	CXMLSettings x;
//	int iScriptEnable;

	cstrFile = theApp.GetProfileString( "SettingsFile", "FileName", cstrFile );

	// Use a default if nothing is configured
	if (cstrFile == "")
	{
		cstrFile = "default.xml";
	}

	SetHandsetSettings();

	// Get the COM settings
	for (int i=0; i<10; i++)
	{
		CString csCom;
		csCom.Format( "hsPort%d", i+1 );

		m_csComPort[i] = theApp.GetProfileString( "SettingsFile", csCom, "-" );
	}

	// Make sure these paths exist
	_mkdir( SCP_BASE_PATH );
	_mkdir( LOG_BASE_PATH );

	// Add a string to the list box
	AddToStatusList("Starting SerialScript");

    m_hFilOpnBmp.LoadBitmap(IDB_OPNFIL);

	// New Open File Stuff
    m_bFilOpn1.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn2.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn3.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn4.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn5.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn6.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn7.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn8.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn9.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn10.ModifyStyle(0, BS_BITMAP);
    m_bFilOpn1.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn2.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn3.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn4.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn5.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn6.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn7.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn8.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn9.SetBitmap(m_hFilOpnBmp);
    m_bFilOpn10.SetBitmap(m_hFilOpnBmp);

    m_hScriptBmp.LoadBitmap(IDB_SCRIPT);
	m_bScriptBrowse1.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse2.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse3.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse4.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse5.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse6.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse7.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse8.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse9.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse10.ModifyStyle(0, BS_BITMAP);
	m_bScriptBrowse1.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse2.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse3.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse4.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse5.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse6.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse7.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse8.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse9.SetBitmap(m_hScriptBmp);
	m_bScriptBrowse10.SetBitmap(m_hScriptBmp);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSerialScriptDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSerialScriptDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSerialScriptDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



// Send a message from the active COMPort
//
void CSerialScriptDlg::SendString( char *strSend )
{
	strcpy( sendBuffer, strSend );
	sendLength = strlen(sendBuffer);
    sendActivate = TRUE;

	// Wait until string is sent
	do
	{
		Sleep(100);
	} while( sendActivate );
}


void CSerialScriptDlg::OnOpenPort() 
{
	UpdateData(TRUE);
	UpdateConfig();

	// Start
	closePortActivate = false;
	openPortActivate = true;
	activeProccess = TRUE;
	UpdateData(TRUE);
	serialProcess->ResumeThread();

//	m_monitorRec = _T("");

	iNumProcessPackets=0;
	iNumProcessBytes=0;

	UpdateData(FALSE);
}


void CSerialScriptDlg::OnOpenError()
{
	// Set signal of closing port serial communication.
	closePortActivate =  true;
	openPortActivate = false;
}


void CSerialScriptDlg::CloseFiles()
{
	if (fdWrite!=NULL)
	{
		fclose(fdWrite);
		fdWrite=NULL;
	}

	if (fdTrace!=NULL)
	{
		fclose(fdTrace);
		fdTrace=NULL;
	}
}


void CSerialScriptDlg::OnClosePort() 
{
	// Set signal of closing port serial communication.
	closePortActivate =  true;
	openPortActivate = false;
	bInFileTransfer = false;

	CloseFiles();

	// Sleep(5000);

	// UpdateData(FALSE);
}


void CSerialScriptDlg::UpdateConfig()
{
	// constant parameter.
	configSerial_.ByteSize = 8;
	configSerial_.StopBits = ONESTOPBIT;
	configSerial_.Parity   = NOPARITY;
	configSerial_.BaudRate = CBR_115200;

	m_namePort1 = "COM50";
	m_namePort = m_namePort1;


}


void CSerialScriptDlg::OnCancel()
{
	UpdateData(TRUE);

	closePortActivate =  true;
	openPortActivate = false;

	// Set signal of closing port serial communication.
	serialProcess->SuspendThread();

	CDialog::OnCancel();
}


void CSerialScriptDlg::OnComplete()
{
	CloseFiles();

	PlaySound(MAKEINTRESOURCE(IDR_WAVE1), NULL, SND_RESOURCE|SND_SYNC );
	AfxMessageBox("Data Collection successful.");
}



// Receive data from incoming call
//
#define MAX_STRING		512

void CSerialScriptDlg::OnProcess( char * inputData, unsigned long length )
{
	int result;
	char * word;

	if (closePortActivate)
		return;

	static char str[MAX_STRING], *pEnd;
	static int  strInx=0;

	if (length > 0)
	{
		if ( (length+strInx) < MAX_STRING )
		{
			strncpy( &str[strInx], inputData, length );
			str[strInx+length] = 0;

			strInx += length;
		}
		else
		{
			// Just throw away the data
			strInx=0;
		}

		// Check for a return
		if ( pEnd = strchr( str, '\r' ) )
		{
			*pEnd = 0;

			// Concatenate this string until max string received OR \n
			CString cs;
			cs.Format( "%s\n", str );
			OutputDebugString( cs );

			// Process it
			if ((result = _strnicmp(str, "RING", 4)) == 0)
			{ 
				incomingCall = TRUE;  // incoming call
				word = strtok(str, " "); // separate 1st RING word 
				word1 = word;  // 1st RING word
				word = strtok (NULL, " "); // CLID
				word2 = word;

				if (word2 == "CLID")
				{	
					word = strtok (NULL, " "); // CallerID phone number
					cnum = word;
					csNumber = cnum;
					cnum = " Number=" + cnum + ";";
					word = strtok (NULL, " "); // CallerID last name
					CString cname1 = word;
					word = strtok (NULL, " "); // CallerID first name
					CString cname2 = word;
					csName = cname1 + " " + cname2;
					cname = " Name=" + cname1 + " " + cname2;
					cid = cnum + cname;
					incomingCallID = TRUE;	// incoming call with Caller ID	
				}
			}

			// Clear the string
			strInx=0;
		}
	}
}


BOOL CSerialScriptDlg::FileExists(LPCSTR szFile)
{
	DWORD	dwFileAttrib;
	BOOL	bFileExists;

	// let's make sure the source file exists
	dwFileAttrib = GetFileAttributes(szFile);
	bFileExists = (dwFileAttrib == 0xffffffff) ? FALSE : TRUE;
	if (!bFileExists)
	{
		return FALSE;
	}
	return TRUE;
}


// LogBegin - this routine is called only once, on the Start button
// Reads the current setups for all Com ports 
// Writes the information for each Active Setup to the first lines of the Log file
//
void CSerialScriptDlg::LogBegin()
{   
	int enableNum;
	CString j;

	handSet = "    Active Setups ";
	Log(handSet);

	for(int i=0; i<10; i++)
		{
		switch (i)
			{
				case 0:  enableNum = m_enable1.GetCheck(); break;
				case 1:  enableNum = m_enable2.GetCheck(); break;
				case 2:  enableNum = m_enable3.GetCheck(); break;
				case 3:  enableNum = m_enable4.GetCheck(); break;
				case 4:  enableNum = m_enable5.GetCheck(); break;
				case 5:  enableNum = m_enable6.GetCheck(); break;
				case 6:  enableNum = m_enable7.GetCheck(); break;
				case 7:  enableNum = m_enable8.GetCheck(); break;
				case 8:  enableNum = m_enable9.GetCheck(); break;
				case 9:  enableNum = m_enable10.GetCheck();
			}

			CString csDelay, csScript = "";
			
			if (enableNum == 1)  // if enabled
				{
				switch (i)
					{
					case 0:  j = "Setup1: Delay "; 
						m_delay1.GetWindowTextA(csDelay);  
						m_script_name1.GetWindowTextA(csScript);	 
						break;
					case 1:  j = "Setup2: Delay "; 
						m_delay2.GetWindowTextA(csDelay);
						m_script_name2.GetWindowTextA(csScript);					
						break;
					case 2:  j = "Setup3: Delay "; 
						m_delay3.GetWindowTextA(csDelay);
						m_script_name3.GetWindowTextA(csScript);					
						break;
					case 3:  j = "Setup4: Delay "; 
						m_delay4.GetWindowTextA(csDelay);
						m_script_name4.GetWindowTextA(csScript);					
						break;
					case 4:  j = "Setup5: Delay "; 
						m_delay5.GetWindowTextA(csDelay);
						m_script_name5.GetWindowTextA(csScript);					
						break;
					case 5:  j = "Setup6: Delay "; 
						m_delay6.GetWindowTextA(csDelay);
						m_script_name6.GetWindowTextA(csScript);					
						break;
					case 6:  j = "Setup7: Delay "; 
						m_delay7.GetWindowTextA(csDelay);
						m_script_name7.GetWindowTextA(csScript);					
						break;
					case 7:  j = "Setup8: Delay "; 
						m_delay8.GetWindowTextA(csDelay);
						m_script_name8.GetWindowTextA(csScript);					
						break;
					case 8:  j = "Setup9: Delay "; 
						m_delay9.GetWindowTextA(csDelay);
						m_script_name9.GetWindowTextA(csScript);					
						break;
					case 9:  j = "Setup10: Delay ";
						m_delay10.GetWindowTextA(csDelay);
						m_script_name10.GetWindowTextA(csScript);
					}
			
				handSet = j + csDelay + "sec " + csScript;
				Log(handSet);  // write once per enabled setup
			}
		}  // end FOR loop
			
	logStartup = 0;

	handSet = "    Testing Begins ";
	Log(handSet);
}


// Create a Log file
// Write all Script requests and test results to the Log file
//
#include <sys/timeb.h>

void CSerialScriptDlg::Log( CString strMessage )  
{
	CString csFile;
	CString csLogMsg;
	int result;

	static HANDLE fprintf_lock = NULL;
	static int b_Fprintf_Initialized = FALSE;

	CString csHandSet = strMessage;
	CTime timeWrite;
	timeWrite = CTime::GetCurrentTime();

    struct _timeb tstruct;
	_ftime( &tstruct );

	// set up a new file name
	// once for each Start button click
	if (newLogFile == 1)
	{   
		m_script_suite.GetWindowTextA(csFile);  // read from Test Scenario window
		csFile.Replace(".xml", ".txt");
		logFile = timeWrite.Format("%Y_%m%d_%H%M_%S_") + csFile;
		newLogFile = 0;
		cstrFilePath = CString(LOG_BASE_PATH) + "\\" + logFile;
		FILE *stream;
		stream = _fsopen( cstrFilePath, "w", _SH_DENYWR );   // create a new file

		if (stream != NULL)
		{
			fclose( stream );
		}
		else
		{
			csLogMsg = "  CREATION OF LOG FILE FAILED";
			AddToStatusList(csLogMsg);
			OnBnClickedStop();
		}
	}

	//cstrFilePath = CString(LOG_BASE_PATH) + "\\" + logFile;

	if( !b_Fprintf_Initialized )
	{
		fprintf_lock = CreateMutex(NULL, FALSE, NULL); 
		b_Fprintf_Initialized = TRUE;
	}

//	for(int i=0; i<10; i++)
//	{
		// acquiring the mutex lock
		WaitForSingleObject( fprintf_lock, INFINITE );  
	
		FILE *stream;
		stream = _fsopen( cstrFilePath, "r+", _SH_DENYWR );   // open file for writing

		if (stream != NULL)
		{
			csLogMsg = timeWrite.Format("%y/%m/%d %H:%M:%S ") + csHandSet;

			result = fseek( stream, 40L, SEEK_END ); // set to end of file to allow append
			if (result)
			{
				csLogMsg = csHandSet + "  SEEK_END FAILED";
				AddToStatusList(csLogMsg);
				OnBnClickedStop();  // stop testing
				ReleaseMutex( fprintf_lock ); 
				return;
			}
			fprintf( stream, "\n" + csLogMsg );
			fclose( stream );
			AddToStatusList(csLogMsg);
			ReleaseMutex( fprintf_lock ); 
			return;  // passed
		}	
		else 
		{ 
			csLogMsg = csHandSet + "  LOG FAILED";
			AddToStatusList(csLogMsg);
			Sleep(10);
		}		
	OnBnClickedStop();   // on failure, stops the ScriptThread While loop and testing
	ReleaseMutex( fprintf_lock ); 
}  


// START button
// Open COM ports
// Start threads for testing and logging
//
void CSerialScriptDlg::OnBnClickedStart()
{
	CString csHandsetId;
	CString csScriptFileName;
	CString csDelay;
	int  enabled = 0;
	char ch = 10; // line feed

	if (scriptFileOpens == 0) 
	{	// do not allow testing if a Script file will not open
		MessageBox("Script File " + failingScriptFile + " will not open!" + ch +
			"You must fix this problem before testing.", "Error", MB_OK );
		return;
	}

	OnBnClickedRcvclr();  // Clear the Monitor Receiving Messages window

	DTMF[0] = "0123"; // HS1 dial code
	DTMF[1] = "1234"; // HS2 dial code
	DTMF[2] = "2345";
	DTMF[3] = "3456";
	DTMF[4] = "4567";
	DTMF[5] = "5678";
	DTMF[6] = "6789";
	DTMF[7] = "7890";
	DTMF[8] = "8901";
	DTMF[9] = "9012";

	newLogFile = 1;  // set to open a new Log file 
	LogBegin();      // setup the new Log file with initial handset data
	stopLog = 0;
	runTime = m_cbRepeat.GetCurSel(); // 0 = Forever, 1 = Once

	m_btnStart.EnableWindow( FALSE ); // disable START button
	m_btnStop.EnableWindow( TRUE ); // enable STOP button

		m_enable1.EnableWindow( FALSE ); // disable Handset Check button 
		m_enable2.EnableWindow( FALSE );
		m_enable3.EnableWindow( FALSE );
		m_enable4.EnableWindow( FALSE );
		m_enable5.EnableWindow( FALSE );
		m_enable6.EnableWindow( FALSE );
		m_enable7.EnableWindow( FALSE );
		m_enable8.EnableWindow( FALSE );
		m_enable9.EnableWindow( FALSE );
		m_enable10.EnableWindow( FALSE );
		m_delay1.EnableWindow( FALSE );  // disable Delay window
		m_delay2.EnableWindow( FALSE ); 
		m_delay3.EnableWindow( FALSE ); 
		m_delay4.EnableWindow( FALSE ); 
		m_delay5.EnableWindow( FALSE ); 
		m_delay6.EnableWindow( FALSE ); 
		m_delay7.EnableWindow( FALSE ); 
		m_delay8.EnableWindow( FALSE ); 
		m_delay9.EnableWindow( FALSE ); 
		m_delay10.EnableWindow( FALSE ); 
		m_script_name1.EnableWindow( FALSE );  // disable Script window
		m_script_name2.EnableWindow( FALSE );
		m_script_name3.EnableWindow( FALSE );
		m_script_name4.EnableWindow( FALSE );
		m_script_name5.EnableWindow( FALSE );
		m_script_name6.EnableWindow( FALSE );
		m_script_name7.EnableWindow( FALSE );
		m_script_name8.EnableWindow( FALSE );
		m_script_name9.EnableWindow( FALSE );
		m_script_name10.EnableWindow( FALSE );

		m_bScriptBrowse1.EnableWindow( FALSE );
		m_bScriptBrowse2.EnableWindow( FALSE );
		m_bScriptBrowse3.EnableWindow( FALSE );
		m_bScriptBrowse4.EnableWindow( FALSE );
		m_bScriptBrowse5.EnableWindow( FALSE );
		m_bScriptBrowse6.EnableWindow( FALSE );
		m_bScriptBrowse7.EnableWindow( FALSE );
		m_bScriptBrowse8.EnableWindow( FALSE );
		m_bScriptBrowse9.EnableWindow( FALSE );
		m_bScriptBrowse10.EnableWindow( FALSE );

		m_btnRestore.EnableWindow( FALSE );
		m_btnNew.EnableWindow( FALSE );
		m_btnSave.EnableWindow( FALSE );
		m_btnDelete.EnableWindow( FALSE );
		m_btnConfig.EnableWindow( FALSE );
		m_cbRepeat.EnableWindow( FALSE );
		m_script_suite.EnableWindow( FALSE );
		m_btnLoadsuite.EnableWindow( FALSE );

	scriptActive = true;

	logStartup = 1;

	// Open the COM Port for this thread
	OnOpenPort();

	// Begin running ScriptThread for each enabled handset
	if (m_enable1.GetCheck())  // Start thread for handset 1 if enabled
	{   
		csHandsetId = "1";

		ThreadStart( csHandsetId, m_namePort1, m_script_name1, m_delay1 );
		enabled = 1;
	}

	if (m_enable2.GetCheck())  // Start thread for handset 2 if enabled
	{   
		csHandsetId = "2";

		ThreadStart( csHandsetId, m_namePort2, m_script_name2, m_delay2 );
		enabled = 1;
	}

	if (m_enable3.GetCheck())  // Start thread for handset 3 if enabled
	{   
		csHandsetId = "3";

		ThreadStart( csHandsetId, m_namePort3, m_script_name3, m_delay3 );
		enabled = 1;
	}

	if (m_enable4.GetCheck())  // Start thread for handset 4 if enabled
	{   
		csHandsetId = "4";

		ThreadStart( csHandsetId, m_namePort4, m_script_name4, m_delay4 );
		enabled = 1;
	}

	if (m_enable5.GetCheck())  // Start thread for handset 5 if enabled
	{   
		csHandsetId = "5";

		ThreadStart( csHandsetId, m_namePort5, m_script_name5, m_delay5 );
		enabled = 1;
	}

	if (m_enable6.GetCheck())  // Start thread for handset 6 if enabled
	{   
		csHandsetId = "6";

		ThreadStart( csHandsetId, m_namePort6, m_script_name6, m_delay6 );
		enabled = 1;
	}

	if (m_enable7.GetCheck())  // Start thread for handset7 if enabled
	{   
		csHandsetId = "7";

		ThreadStart( csHandsetId, m_namePort7, m_script_name7, m_delay7 );
		enabled = 1;
	}

	if (m_enable8.GetCheck())  // Start thread for handset 8 if enabled
	{   
		csHandsetId = "8";

		ThreadStart( csHandsetId, m_namePort8, m_script_name8, m_delay8 );
		enabled = 1;
	}

	if (m_enable9.GetCheck())  // Start thread for handset 9 if enabled
	{   
		csHandsetId = "9";

		ThreadStart( csHandsetId, m_namePort9, m_script_name9, m_delay9 );
		enabled = 1;
	}

	if (m_enable10.GetCheck())  // Start thread for handset 10 if enabled
	{   
		csHandsetId = "10";

		ThreadStart( csHandsetId, m_namePort10, m_script_name10, m_delay10 );
		enabled = 1;
	}
		
	if (enabled == 0)  // if no handsets are enabled
	{
		Log(" No devices enabled ");
		CString noDevices = "No devices enabled.";
		MessageBox( noDevices + ch +
			"You must fix this problem before testing.", "Error", MB_OK );
		OnBnClickedStop();
	}
}


// STOP button
// Stop all testing and logging
//
void CSerialScriptDlg::OnBnClickedStop()
{
	stopLog = 1;  // used to stop the While test/log loop in ScriptThread

    scriptActive = false; 
    Sleep(100);

	m_btnStart.EnableWindow( TRUE );  // enable START button	
	m_btnStop.EnableWindow( FALSE );  // disable STOP button

		m_enable1.EnableWindow( TRUE ); // enable Handset Check button 
		m_enable2.EnableWindow( TRUE );
		m_enable3.EnableWindow( TRUE );
		m_enable4.EnableWindow( TRUE );
		m_enable5.EnableWindow( TRUE );
		m_enable6.EnableWindow( TRUE );
		m_enable7.EnableWindow( TRUE );
		m_enable8.EnableWindow( TRUE );
		m_enable9.EnableWindow( TRUE );
		m_enable10.EnableWindow( TRUE );
		m_delay1.EnableWindow( TRUE );  // enable Delay window
		m_delay2.EnableWindow( TRUE ); 
		m_delay3.EnableWindow( TRUE ); 
		m_delay4.EnableWindow( TRUE ); 
		m_delay5.EnableWindow( TRUE ); 
		m_delay6.EnableWindow( TRUE ); 
		m_delay7.EnableWindow( TRUE ); 
		m_delay8.EnableWindow( TRUE ); 
		m_delay9.EnableWindow( TRUE ); 
		m_delay10.EnableWindow( TRUE ); 
		m_script_name1.EnableWindow( TRUE );  // enable Script window
		m_script_name2.EnableWindow( TRUE );
		m_script_name3.EnableWindow( TRUE );
		m_script_name4.EnableWindow( TRUE );
		m_script_name5.EnableWindow( TRUE );
		m_script_name6.EnableWindow( TRUE );
		m_script_name7.EnableWindow( TRUE );
		m_script_name8.EnableWindow( TRUE );
		m_script_name9.EnableWindow( TRUE );
		m_script_name10.EnableWindow( TRUE );

		m_bScriptBrowse1.EnableWindow( TRUE );
		m_bScriptBrowse2.EnableWindow( TRUE );
		m_bScriptBrowse3.EnableWindow( TRUE );
		m_bScriptBrowse4.EnableWindow( TRUE );
		m_bScriptBrowse5.EnableWindow( TRUE );
		m_bScriptBrowse6.EnableWindow( TRUE );
		m_bScriptBrowse7.EnableWindow( TRUE );
		m_bScriptBrowse8.EnableWindow( TRUE );
		m_bScriptBrowse9.EnableWindow( TRUE );
		m_bScriptBrowse10.EnableWindow( TRUE );

		m_btnRestore.EnableWindow( TRUE );
		m_btnNew.EnableWindow( TRUE );
		m_btnSave.EnableWindow( TRUE );
		m_btnDelete.EnableWindow( TRUE );
		m_btnConfig.EnableWindow( TRUE );
		m_cbRepeat.EnableWindow( TRUE );
		m_script_suite.EnableWindow( TRUE );
		m_btnLoadsuite.EnableWindow( TRUE );

	OnClosePort();
}


// Allow choice of a new script file
//
void CSerialScriptDlg::OnGetScript( CEdit &m_script_name )
{	
	CString csFileName;

    CFileDialog dlgFile(TRUE,NULL,NULL,OFN_OVERWRITEPROMPT,"Script Files (*.txt)|*.txt||");

	CString fileName;
	const int c_cMaxFiles = 100;
	const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
	dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
	dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
	dlgFile.m_ofn.lpstrInitialDir = SCP_BASE_PATH;

	dlgFile.DoModal();					 // open the selection window
	csFileName = dlgFile.GetFileName();  // retrieve the selected file name
	fileName.ReleaseBuffer();			 // close the selection window

	m_script_name.SetWindowTextA(csFileName);  // change the script file name in dialog window

	scriptChange = TRUE;  // flag to show a script was changed
}


// Set of Browse routines to write a new Script name for any handset
// Activated when a Script Browse button is selected
//
void CSerialScriptDlg::OnSelectScript1()
{
	OnGetScript(m_script_name1);
}

void CSerialScriptDlg::OnSelectScript2()
{
	OnGetScript(m_script_name2);
}

void CSerialScriptDlg::OnSelectScript3()
{
	OnGetScript(m_script_name3);
}

void CSerialScriptDlg::OnSelectScript4()
{
	OnGetScript(m_script_name4);
}

void CSerialScriptDlg::OnSelectScript5()
{
	OnGetScript(m_script_name5);
}

void CSerialScriptDlg::OnSelectScript6()
{
	OnGetScript(m_script_name6);
}

void CSerialScriptDlg::OnSelectScript7()
{
	OnGetScript(m_script_name7);
}

void CSerialScriptDlg::OnSelectScript8()
{
	OnGetScript(m_script_name8);
}

void CSerialScriptDlg::OnSelectScript9()
{
	OnGetScript(m_script_name9);
}

void CSerialScriptDlg::OnSelectScript10()
{
	OnGetScript(m_script_name10);
}


// Write handset settings to dialog window
// Force verification that each active Script file will open
//
void CSerialScriptDlg::SetHandsetSettings()
{
	CString csComment;
	CString csDelay;
	CString csRepeat;
	CXMLSettings x;
	CString xml_STRING_HANDSET;

	scriptFileOpens = 1;  // used for verification of Script files

	m_script_suite.SetWindowTextA(cstrFile);

	// Add the base path
	cstrFilePath = CString(SCP_BASE_PATH) + "\\" + cstrFile;

	x.SetSettingsFile(cstrFilePath);  // open the Suite XML file

	csComment = x.GetSettingString( XML_STRING_COMMENT, "text", "");
	m_edComment.SetWindowTextA(csComment);

	csRepeat = x.GetSettingString( XML_STRING_REPEAT, "repeat", "");
	if (csRepeat == "Forever")
	{
	m_cbRepeat.SetCurSel(0);
	}
	else 
	{  
		m_cbRepeat.SetCurSel(1);  
	}

	// Retrieves and writes to dialog the setup from XML file
	GetSetSuiteSettings(XML_STRING_HANDSET1, m_script_name1, m_delay1, m_enable1 );
	GetSetSuiteSettings(XML_STRING_HANDSET2, m_script_name2, m_delay2, m_enable2 );
	GetSetSuiteSettings(XML_STRING_HANDSET3, m_script_name3, m_delay3, m_enable3 );
	GetSetSuiteSettings(XML_STRING_HANDSET4, m_script_name4, m_delay4, m_enable4 );
	GetSetSuiteSettings(XML_STRING_HANDSET5, m_script_name5, m_delay5, m_enable5 );
	GetSetSuiteSettings(XML_STRING_HANDSET6, m_script_name6, m_delay6, m_enable6 );
	GetSetSuiteSettings(XML_STRING_HANDSET7, m_script_name7, m_delay7, m_enable7 );
	GetSetSuiteSettings(XML_STRING_HANDSET8, m_script_name8, m_delay8, m_enable8 );
	GetSetSuiteSettings(XML_STRING_HANDSET9, m_script_name9, m_delay9, m_enable9 );
	GetSetSuiteSettings(XML_STRING_HANDSET10, m_script_name10, m_delay10, m_enable10 );

	return;
}


// Read the Suite settings from the XML file
// Write all Dialog window settings
//
void  CSerialScriptDlg::GetSetSuiteSettings(CString cstrHSsettingsPath, CEdit &m_script_name, CEdit &m_delay, CButton &m_enable )
{
	CString csScript;
	CString csDelay;
	int iScriptEnable;
	CXMLSettings x;

	x.SetSettingsFile(cstrFilePath);  // open the Suite XML file

	csScript = x.GetSettingString( cstrHSsettingsPath, "script", "" );
	m_script_name.SetWindowTextA(csScript);
	csDelay  = x.GetSettingString( cstrHSsettingsPath, "delay", "" );
	m_delay.SetWindowTextA(csDelay);
	iScriptEnable = x.GetSettingLong( cstrHSsettingsPath, "enable", 0 );
	m_enable.SetCheck(iScriptEnable);
	if (iScriptEnable == 1) 
		{ ScriptFileCheck(csScript); } // verify Script file can be opened
}


// Verify that each active Script file can be opened
//
void CSerialScriptDlg::ScriptFileCheck(CString csScript)
{   
	char ch = 10;  // line feed
	
	CString cstrScriptFilePath = CString(SCP_BASE_PATH) + "\\" + csScript; 

	FILE *stream;
	stream = _fsopen( cstrScriptFilePath, "r", _SH_DENYWR );   // open file 

	if (stream != NULL)   // if the file opened, no action
	{	fclose( stream );  }  // close the file
	else
	{	scriptFileOpens = FALSE;	  // used to prevent the threads starting 
		m_btnStart.EnableWindow( FALSE );  // disable START button	
		failingScriptFile = csScript;
		MessageBox("Script File " + failingScriptFile + " will not open!" + ch +
			"You must fix this problem before testing.", "Error", MB_OK );
	}
}


// RESTORE button
// Restores current handset suite to the dialog window
//
void CSerialScriptDlg::OnBnClickedRestore()
{
	m_script_suite.GetWindowTextA(cstrFile);  // read from Test Scenario window
	theApp.GetProfileString( "SettingsFile", "FileName", cstrFile );

	SetHandsetSettings();  // set handset settings in dialog window
}


// Displays MessageBox if changes to handset settings have been made
//
int CSerialScriptDlg::CompareAndSave()
{
	TestSuiteCompare(); // checks enable and delay for changes

	if (tsChange == 1 || newUnsaved == 1 || scriptChange == TRUE)  // if there are changes
	{
		tsChange, newUnsaved = 0;
		scriptChange = FALSE;
		int nResponse = MessageBox("Do you wish to save the current test suite?", "Question", MB_YESNOCANCEL | MB_ICONQUESTION);

		if (nResponse == IDYES)  // YES button selected
		{
			OnBnClickedSave();		// open SAVE AS dialog
			return nResponse;
		}
		else if (nResponse == IDCANCEL) 
		{ 
			return nResponse; 
		}
	}

	return IDNO;
}


// Test Scenario selection window
//
void CSerialScriptDlg::OnLoadTestSuite()
{
	CompareAndSave();

	CFileDialog dlgFile(TRUE,NULL,NULL,OFN_OVERWRITEPROMPT,"SerialScripter Test Suite (*.xml)|*.xml||");

	CString fileName;
	const int c_cMaxFiles = 100;
	const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
	dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
	dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
	dlgFile.m_ofn.lpstrInitialDir = SCP_BASE_PATH;

	int sResponse = dlgFile.DoModal();  // open the window
	fileName.ReleaseBuffer();

	if (sResponse != IDCANCEL) 
	{
		// get file name and change script box
		cstrFile = dlgFile.GetFileName();
		m_script_suite.SetWindowTextA(cstrFile); 
		theApp.WriteProfileString( "SettingsFile", "FileName", cstrFile );

		SetHandsetSettings();  // set handset settings in dialog box
	}
}


// Test Scenario -- check for edits in Enable and Delay
// Compares XML Suite file to dialog box
//
void CSerialScriptDlg::TestSuiteCompare()
{
	CString csDelay1, csDelay2, csRepeat;
	CXMLSettings x;
	int iScriptEnable1, iScriptEnable2;
	CString filePath;
	CString csFile;
	int y, z;

	m_script_suite.GetWindowTextA(csFile); 
		// Add the base path
	filePath = CString(SCP_BASE_PATH) + "\\" + csFile;

	x.SetSettingsFile(filePath);

	// Retrieves setups from XML file and dialog box

	// Repeat...
	csRepeat = x.GetSettingString( XML_STRING_REPEAT, "repeat", "");  // XML file setting
	if (csRepeat == "Forever")
	{
		y = 0;
	}
	else 
	{  
		y = 1;    // "Once"
	}

	z = m_cbRepeat.GetCurSel();  // dialog box setting
	if (z != y)
	{
		tsChange = 1;
		return;
	}

	// Handset1...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET1, "delay", "" );  // XML file setting
	m_delay1.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET1, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable1.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset2...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET2, "delay", "" );  // XML file setting
	m_delay2.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET2, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable2.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset3...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET3, "delay", "" );  // XML file setting
	m_delay3.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET3, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable3.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset4...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET4, "delay", "" );  // XML file setting
	m_delay4.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET4, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable4.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset5...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET5, "delay", "" );  // XML file setting
	m_delay5.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET5, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable5.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset6...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET6, "delay", "" );  // XML file setting
	m_delay6.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET6, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable6.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset7...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET7, "delay", "" );  // XML file setting
	m_delay7.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET7, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable7.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset8...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET8, "delay", "" );  // XML file setting
	m_delay8.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET8, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable8.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset9...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET9, "delay", "" );  // XML file setting
	m_delay9.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET9, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable9.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

		// Handset10...
	csDelay1  = x.GetSettingString( XML_STRING_HANDSET10, "delay", "" );  // XML file setting
	m_delay10.GetWindowTextA(csDelay2);   // get dialog box delay
	iScriptEnable1 = x.GetSettingLong( XML_STRING_HANDSET10, "enable", 0 ); // XML file setting
    iScriptEnable2 = m_enable10.GetCheck();   // dialog box setting
	if ((csDelay1 != csDelay2) || (iScriptEnable1 != iScriptEnable2))
	{
		tsChange = 1;
		return;
	}

	tsChange = 0;
}


// NEW button
// Loads default handset setups to dialog and set a temporary filename
// Creates a starting point for a setup to be edited and saved with a new name
//
void CSerialScriptDlg::OnBnClickedNew()
{
	bIsValidFile = false;

	cstrFile = "default.xml";
	SetHandsetSettings();  // load default settings

	cstrFile = "xxxx.xml";  // set a temporary file name
	m_script_suite.SetWindowTextA(cstrFile); 
	newUnsaved = 1;  // set flag for later SAVE

	CNewSuiteDlg dlg;  // Attachment to NewSuiteDlg
	int rtn = dlg.DoModal();  // display the New Test Suite dialog box
	if (rtn == IDOK)
	{
		bIsValidFile = true;

		// get Test Scenario file name
		// If there is no .xml, add it
		cstrFile = dlg.m_newsuiteFname;
		if ( !strstr(cstrFile,".xml") )
		{
			cstrFile += ".xml";
		}

		m_script_suite.SetWindowTextA(cstrFile); // write to Test Scenario box

		OnBnClickedSave();  // save the file
	}
}


// SAVE button
// Saves handset setups to XML file
//
void CSerialScriptDlg::OnBnClickedSave()
{
    // If we already know the filename, then we don't need to prompt
	if (!bIsValidFile)
	{
		CFileDialog dlgFile(FALSE,NULL,
			cstrFile,OFN_OVERWRITEPROMPT,
			"SerialScripter Projects (*.xml)|*.xml||");

		CString fileName;
		const int c_cMaxFiles = 100;
		const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
		dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
		dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
		dlgFile.m_ofn.lpstrInitialDir = SCP_BASE_PATH;

		if (dlgFile.DoModal() == IDOK)  // open SAVE file window
		{
			fileName.ReleaseBuffer();
			cstrFile = dlgFile.GetFileName();  // get the saved file name
			m_script_suite.SetWindowTextA(cstrFile); // write to Test Scenario box

		}
		else 
		{
			fileName.ReleaseBuffer();
		}

		bIsValidFile = true;
	}

	HandsetSettingsToXML();  // opens the file and saves the data

	MessageBox( "File " + cstrFile + " has been saved.", "Message", MB_OK);

	m_script_suite.GetWindowTextA(cstrFile);  // read from Test Scenario window
	theApp.GetProfileString( "SettingsFile", "FileName", cstrFile );

	SetHandsetSettings();  // reset handset settings in dialog window to check that files open
}


// Retrieve handset settings for write to XML file
//
void CSerialScriptDlg::HandsetSettingsToXML()
{
	CString csComment;
	CString csScript;
	CString csDelay;
	CString csRepeat;
	CXMLSettings x;
	int y;

	cstrFile = CString(SCP_BASE_PATH) + "\\" + cstrFile;
	x.SetSettingsFile(cstrFile);  // open the file

	y = m_cbRepeat.GetCurSel();
	if (y == 0)
	{
		csRepeat = "Forever";
	}
	else 
	{ 
		csRepeat = "Once"; 
	}
	x.SetSettingString( XML_STRING_REPEAT, "repeat", csRepeat);

	m_edComment.GetWindowTextA(csComment);
	x.SetSettingString( XML_STRING_COMMENT, "text", csComment);

	// Handset1
	m_script_name1.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET1, "script", csScript);
	m_delay1.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET1, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET1, "enable", m_enable1.GetCheck() ) ;

	// Handset2
	m_script_name2.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET2, "script", csScript) ;
	m_delay2.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET2, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET2, "enable", m_enable2.GetCheck() ) ;

	// Handset3
	m_script_name3.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET3, "script", csScript) ;
	m_delay3.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET3, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET3, "enable", m_enable3.GetCheck() ) ;

	// Handset4
	m_script_name4.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET4, "script", csScript) ;
	m_delay4.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET4, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET4, "enable", m_enable4.GetCheck() ) ;

	// Handset5
	m_script_name5.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET5, "script", csScript);
	m_delay5.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET5, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET5, "enable", m_enable5.GetCheck() ) ;

	// Handset6
	m_script_name6.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET6, "script", csScript) ;
	m_delay6.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET6, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET6, "enable", m_enable6.GetCheck() ) ;

	// Handset7
	m_script_name7.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET7, "script", csScript);
	m_delay7.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET7, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET7, "enable", m_enable7.GetCheck() ) ;

	// Handset8
	m_script_name8.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET8, "script", csScript) ;
	m_delay8.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET8, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET8, "enable", m_enable8.GetCheck() ) ;

	// Handset9
	m_script_name9.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET9, "script", csScript);
	m_delay9.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET9, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET9, "enable", m_enable9.GetCheck() ) ;

	// Handset10
	m_script_name10.GetWindowTextA(csScript);
	x.SetSettingString( XML_STRING_HANDSET10, "script", csScript) ;
	m_delay10.GetWindowTextA(csDelay);
	x.SetSettingString( XML_STRING_HANDSET10, "delay", csDelay);
	x.SetSettingLong(   XML_STRING_HANDSET10, "enable", m_enable10.GetCheck() ) ;

	return;
}


// DELETE button
// Delete current XML Suite file and set default settings
//
void CSerialScriptDlg::OnBnClickedDelete()
{
	bIsValidFile = false;
	m_script_suite.GetWindowTextA(cstrFile); // read from Test Scenario box

	if(cstrFile != "default.xml")
	{
		cstrFilePath = CString(SCP_BASE_PATH) + "\\" + cstrFile;
		remove(cstrFilePath);  // delete the file 
	}

	cstrFile = "default.xml";
	SetHandsetSettings();
}


void CSerialScriptDlg::OnClose()
{
	if (CompareAndSave() != IDCANCEL)
	{
		CDialog::OnClose();
	}
}

void CSerialScriptDlg::OnBnClickedConfig()
{
	CConfigDlg dlg;

	// Push the settings.
	for (int i=0; i<10; i++)
	{
		dlg.m_csComPort[i] = m_csComPort[i];
	}

	int rtn = dlg.DoModal();  // display the Configuration dialog box

	if (rtn == IDOK)
	{
		// Save the settings.
		for (int i=0; i<10; i++)
		{
			m_csComPort[i] = dlg.m_csComPort[i];

			CString csCom;
			csCom.Format( "hsPort%d", i+1 );

			theApp.WriteProfileString( "SettingsFile", csCom, m_csComPort[i] );
		}
	}
}


// Add a string to the list box
void CSerialScriptDlg::AddToStatusList(LPCTSTR sText)
{
    SYSTEMTIME		logTime;
	GetLocalTime(&logTime);

	// Format the various times
    char strLog[256];
    sprintf( strLog, "%02d/%02d/%02d %02d:%02d:%02d %s",
            logTime.wYear%100,
			logTime.wMonth,
			logTime.wDay,
			logTime.wHour,
			logTime.wMinute,			
			logTime.wSecond,
			sText);

	m_lbRcvMsg.AddString(sText);
	m_lbRcvMsg.SetTopIndex(m_lbRcvMsg.GetCount() - 1);
}


// Open the selected script with notepad for easy viewing and editing.
void CSerialScriptDlg::OnBnClickedOpen1()
{
	ViewScript(m_script_name1);
}

void CSerialScriptDlg::OnBnClickedOpen2()
{
	ViewScript(m_script_name2);
}

void CSerialScriptDlg::OnBnClickedOpen3()
{
	ViewScript(m_script_name3);
}

void CSerialScriptDlg::OnBnClickedOpen4()
{
	ViewScript(m_script_name4);
}

void CSerialScriptDlg::OnBnClickedOpen5()
{
	ViewScript(m_script_name5);
}

void CSerialScriptDlg::OnBnClickedOpen6()
{
	ViewScript(m_script_name6);
}

void CSerialScriptDlg::OnBnClickedOpen7()
{
	ViewScript(m_script_name7);
}

void CSerialScriptDlg::OnBnClickedOpen8()
{
	ViewScript(m_script_name8);
}

void CSerialScriptDlg::OnBnClickedOpen9()
{
	ViewScript(m_script_name9);
}

void CSerialScriptDlg::OnBnClickedOpen10()
{
	ViewScript(m_script_name10);
}



// Open a script with notepad for easy viewing and editing.
void CSerialScriptDlg::ViewScript(CEdit &m_script_name)
{
	CString csScript;
	CString cstrFilePath;

	m_script_name.GetWindowTextA(csScript); // read the script file name

	cstrFilePath = CString(SCP_BASE_PATH) + "\\" + csScript;

	CString cs;
	cs.Format( "notepad.exe %s", cstrFilePath ); // open the script file in Notepad
	WinExec( cs, SW_SHOW );
}


void CSerialScriptDlg::OnBnClickedRcvclr()
{
	m_lbRcvMsg.ResetContent();
}


void CSerialScriptDlg::ThreadStart( CString csHandsetID, CString m_namePort, CEdit &m_script_name, CEdit &m_delay )
{
	CString csScriptFileName;
	CString csComPortId;
	int iComPortId;
	CString csDelay;
	int iDelay;

	scriptProcess = 
			(ScriptThread*)AfxBeginThread(RUNTIME_CLASS(ScriptThread), 
			THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED);
			scriptProcess->setOwner(this);

	csComPortId = m_namePort.GetString();
	sscanf( csComPortId, "%d", &iComPortId );  // convert delay from CString to decimal

	m_script_name.GetWindowTextA(csScriptFileName);

	m_delay.GetWindowTextA(csDelay);
	sscanf( csDelay, "%d", &iDelay );  // convert delay from CString to decimal

	scriptProcess->SetInfo( csHandsetID, csScriptFileName, iComPortId, iDelay );
	scriptProcess->ResumeThread();
}