/********************************************************************
created:	2009/09/18 
filename: 	ScriptThread.cpp
file base:	ScriptThread

purpose:	This class is used to handle the thread of ScriptThread.
*********************************************************************/

#include "stdafx.h"
#include "serialCtl.h"
#include "resource.h"
#include "SerialScriptDlg.h"
#include "ScriptThread.h"

#define SCP_BASE_PATH	"C:\\SerialScript\\Scripts"
const unsigned short MAX_MESSAGE = 1028;

IMPLEMENT_DYNCREATE(ScriptThread,CWinThread)

//ScriptThread::ScriptThread()
//----------------------------------------------------------------------------
//Constructor
//
ScriptThread::ScriptThread()
:ptrDlg(NULL)
{
}

//ScriptThread::~ScriptThread()
//----------------------------------------------------------------------------
//Deconstructor
//
ScriptThread::~ScriptThread()
{
	ptrDlg = NULL;
}

//ScriptThread::InitInstance()
//----------------------------------------------------------------------------
//Deconstructor
//
BOOL
ScriptThread::InitInstance()
{
	return TRUE;
}

// ScriptThread::Run()
//----------------------------------------------------------------------------
// Description: This is a virtual function that is called when thread process
//               is created to be one task.
//
int
ScriptThread::Run()
{
	CString j;
	skip = 0;
	count = 0;
			
	intHS = atoi(csMyHandsetId);  // setup number 
	intHS--;
	testingBegins = 1;
	ptrDlg->stopLog = 0;

	dtmf = ptrDlg->DTMF[intHS]; // setup code for testing

	// Check signal controlling and status to open serial communication.
	// Start process of serial communication operation.

	while(ptrDlg->stopLog != 1)  // stopLog will become 1 when STOP button is pushed
	{
		scriptFile = csScript;  
		ReadScriptFiles(); // read the script data and test

		if (ptrDlg->runTime == 1) // end testing if "Once" selected
		{
			ptrDlg->OnBnClickedStop();
		} 

		Sleep(100);
	}  // end of While loop

	return 0;
}


// Read one line of commands at a time and then call testing after each line
//
void ScriptThread::ReadScriptFiles()
{  	
    int  i, j; 
	int  ch = 0; 
	char ch1 = 10; // line feed
	int  endRead = 0;
	int  hsStart = 1;

	cstrFilePath1 = CString(SCP_BASE_PATH) + "\\" + csMyScriptFileName; 

	FILE *stream;
	stream = _fsopen( cstrFilePath1, "r", _SH_DENYWR );   // open file for reading

	if (stream != NULL)  // if the file opened
	{
		if (hsStart == 1) // trigger initial delay and Log message
		{
			handSet1 = "Setup" + csMyHandsetId;
			handSet = handSet1 + ": Starting script on this COM port";
			ptrDlg->Log(handSet);
			hsStart = 0;

			int ydelay = iMyDelay * 10;  // initial delay for thread start
			DelayExe(ydelay);  // delay before testing

			handSet = handSet1 + ": Initial Delay ";
			ptrDlg->Log(handSet);
		}

		// Read all characters and place them in "commandLine": 
		for( i=0; (i < 100 ) && ( endRead == 0 ); i++ ) // allows up to 100 command lines
		{
			int endLine = 0;
			for( j=0; (j < 80 ) && ( endLine == 0 ); j++ ) // ends on line feed
			{
				ch = fgetc( stream );
				
				if (ch == 10)  // data ends on line feed
				{	commandLine[j] = NULL; 
					endLine = 1;
				}
				else 
				{ 
					commandLine[j] = (char)ch; 
					commands[j] = (char)ch;  
				}
			}
			if ((commandLine[0] == 'R') || (commandLine[0] == 'r') || (commandLine[0] == ' '))
			{  // end reading if "RETURN" or blank
				endRead = 1; 
				handSet = "Setup" + csMyHandsetId;
				handSet = handSet + ": Script loop completed"; 
				ptrDlg->Log(handSet);
			} 
			else 
			{ 
				TestHS( commandLine ); 
			}   // test and log
		}

		fclose( stream );  // close the file after all commands executed
		Sleep(100);
	}  // end of IF

	else   // stops the ScriptThread While loop and testing
	{	
		ptrDlg->stopLog = 1; 
		handSet = "Setup" + csMyHandsetId;
		handSet = handSet + ": Script File " + csMyScriptFileName + " failed to open!"; 
		ptrDlg->Log(handSet);
		MessageBox(NULL,"Script File " + csMyScriptFileName + " failed to open!" + ch1 +
			"Testing has been halted.", "Error", MB_OK );
		ptrDlg->runTime = 1;  // end the ScriptThread While loop
	}
}


// Deconstruct the commands
// Execute commands, and write info to the Log file
//
void ScriptThread::TestHS(char *strCommandLine)
{
	CString ANSWER = "ANSWER";  
	CString ID =  "ID"; 
	CString DELAY =  "DELAY"; 
	CString KEY =  "KEY"; 
	CString LOG =  "LOG"; 
	CString IF =  "IF"; 
	CString ENDIF =  "ENDIF";

	int xdelay;

	CString csCommandLine = strCommandLine;
	CString	ring;
	char	*word;

	word = strtok(strCommandLine," "); // separate 1st command word 
	word1 = word;  // 1st command word

	if (skip == 1)  // skip commands within IF / ENDIF
	{
		if  ((result = _stricmp(word1, ENDIF)) != 0)
		{
			return;
		}
	}

	if  ((result = _stricmp(word1, IF)) != 0) // do not save word2 for IF condition
	{
		if  ((result = _stricmp(word1, LOG)) != 0)  
		{	
			word = strtok (NULL," ");	
			word2 = word;		
		}
		else 
		{	word = strtok (NULL,"$");  }  // save LOG message or IF condition up to any variable

		word2 = word;  // 2nd command word or LOG message	
	}		

// ANSWER command check
	if ((result = _stricmp(word1, ANSWER)) == 0)  // case insensitive
	{
		if ((result = _stricmp(word2, ID)) == 0)
			{ 
				runCase = 1;   // caller ID required
				ptrDlg->SendString( "Waiting for incoming\r\n" );
			}
		else 
		{ 
			runCase = 2;  // no caller ID required
		}
	}
// DELAY command check
	else if ((result = _stricmp(word1, DELAY)) == 0)
		{	
			runCase = 3;  
		}
// KEY command check
	else if ((result = _stricmp(word1, KEY)) == 0)
		{	
			if ((word2 == "F") || (word2 == "f"))  
				{  runCase = 4;  }
			else if ((word2 == "N") || (word2 == "n"))
				{  runCase = 5;  }
			else if ((word2 == "*") || (word2 == "#") ||
					 (word2 == "0") || (word2 == "1") ||
					 (word2 == "2") || (word2 == "3") ||
					 (word2 == "4") || (word2 == "5") ||
					 (word2 == "6") || (word2 == "7") ||
					 (word2 == "8") || (word2 == "9"))
				 {  runCase = 6;  }
			else if (word2 == "$hsid")
				 {  runCase = 7;  }
			else 
			{  
				runCase = 0;    // invalid KEY command
			}
		}
// LOG command check
	else if ((result = _stricmp(word1, LOG)) == 0)
		{	runCase = 8;  }	
// IF command check
	else if ((result = _stricmp(word1, IF)) == 0)
		{	runCase = 9;  }
// ENDIF command check
	else if ((result = _stricmp(word1, ENDIF)) == 0)
		{	runCase = 10;  }
// invalid command
	else 
		{  runCase = 0;  }  

	handSet1 = "Setup" + csMyHandsetId;
	int i = 0;

	switch (runCase) // control of testing and logging
		{
		case 0:  // no test
			handSet = handSet1 + ": Invalid command received"; 
			ptrDlg->Log(handSet);
			break; 
		case 1:   // ANSWER ID - wait for call with caller ID
			handSet = handSet1 + ": Wait for incoming with sender ID ";
			ptrDlg->Log(handSet);
			while (ptrDlg->incomingCallID == FALSE)
			{	
				Sleep(100);     // check for call once each 100msec			
			}
			ring = ptrDlg->cid;
			callerNumber = ptrDlg->csNumber;  // Caller ID number
			callerName = ptrDlg->csName;   // Caller ID name	

			handSet = handSet1 + ": Incoming Message," + ring;  // and sender ID
			ptrDlg->Log(handSet);

			ptrDlg->incomingCallID = FALSE;
			ptrDlg->incomingCall = FALSE;
			break;			
		case 2:  // RECEIVE - wait for message
			handSet = handSet1 + ": Wait for incoming message";
			ptrDlg->Log(handSet);
			while (ptrDlg->incomingCall == FALSE)
			{	
				Sleep(100);     // once each 100msec
			}
			handSet = handSet1 + ": Incoming Message ";
			ptrDlg->Log(handSet);

			ptrDlg->incomingCallID = FALSE;
			ptrDlg->incomingCall = FALSE;
			break;
		case 3:  // DELAY - delay x seconds
			handSet = handSet1 + ": Delay " + word2 + "00 milliseconds";
			ptrDlg->Log(handSet);
			sscanf(word2, "%d", &xdelay);  // convert the to number of 100 mseconds
			DelayExe(xdelay);
			break;
		case 4:   // KEY F - set to send
			KeyF();
			handSet = handSet1 + ": Set to send ";
			ptrDlg->Log(handSet);
			break;
		case 5:   // KEY N - set to receive
			KeyN();
			handSet = handSet1 + ": Set to receive ";
			ptrDlg->Log(handSet);
			break;
		case 6:  // KEY number - dial now
			Dial(csCommandLine+"\r\n");
			handSet = handSet1 + ": Send Digit " + word2;
			ptrDlg->Log(handSet);
			break;
		case 7:  // KEY $hsid - dial this handset 
			DialHSID(KEY+" "+dtmf+"\r\n");
			handSet = handSet1 + ": Send Digits " + dtmf; 
			ptrDlg->Log(handSet);
			break;
		case 8:   // LOG "message"
			word = strtok (NULL," "); // save any message variable
		    word3 = word;
			word = strtok (NULL,""); // save any words after variable
		    word4 = word;
			Message(word3, word4, callerNumber, callerName);
			handSet = handSet1 + ": Message " + word2 + message;
			ptrDlg->Log(handSet);
			break;
		case 9:   // IF condition
			word = strtok (NULL,"$ ");  // remove the variable sign
			csword2 = word;				// save the variable word					
			word = strtok (NULL,"");   // save the condition word
			csword3 = word;

			if (IFcheck(csword2, csword3, callerNumber, callerName) == 1)
			{
				skip = 1;
				handSet2 = "";
			}
			else
			{
				skip = 0;
				handSet2 = " (active)";
			}
			handSet = handSet1 + ": " + csCommandLine + handSet2;
			ptrDlg->Log(handSet);
			// return = 1; if active
			break;
		case 10:   // ENDIF condition
			skip = 0;
			handSet = handSet1 + ": END IF ";
			ptrDlg->Log(handSet);
			break;
		}
}



// Delay per Script file command
//
void ScriptThread::DelayExe(int xdelay)
{	// Delay is in 100msec increments, Sleep is in msec increments
	for (int j = 0; j < xdelay; j++)
		{ Sleep(100); }
}


// Handset to offhook as in answering a call
//
void ScriptThread::KeyF()  
{	// set offhook
	ptrDlg->SendString( "Set to receive\r\n" );
}


// Handset to onhook as in waiting for a call
//
void ScriptThread::KeyN()
{	// set onhook
	ptrDlg->SendString( "Set to not receive\r\n" );
}


// Dial the number or character supplied by the KEY command
//
void ScriptThread::Dial( const char *strKeyMsg )
{
	// dial by sending to serial port
	ptrDlg->SendString( (char*)strKeyMsg );
}


// Dial this handset (based on the KEY command)
//
void ScriptThread::DialHSID( const char *strKeyMsg )
{
	// dial by sending to serial port
	ptrDlg->SendString( (char*)strKeyMsg );
}


// Prepare a Script message (with variables) for Log file display
//
void ScriptThread::Message(const char *strWord3, const char *strWord4, CString callNum, CString callName)
{
	CString worda = (char*)strWord3; // variable
	CString wordb = (char*)strWord4; // any additional words
	CString variable1 = "hsid";
	CString variable2 = "callernum";
	CString variable3 = "callername";
	char quot = 34; // quotation mark in decimal
	message = "";  // clear message

	if ((result = _strnicmp(worda, variable1, 4)) == 0) // if $hsid
	{
		message = "Setup" + csMyHandsetId + " " + wordb;
	}
	else if ((result = _strnicmp(worda, variable2, 9)) == 0) // if $senderid
	{
		message = callNum + " " + wordb + quot;
	}
	else if ((result = _stricmp(worda, variable3)) == 0) // if $sendername
	{
		message = callName + " " + wordb + quot;
	}
}


// IF condition
// Evaluate the condition based on the variable and comparison
// Uses form "IF $variable comparison"
//
int ScriptThread::IFcheck(char *strWord2, char *strWord3, CString strCid1, CString strCid2) 
{
	CString worda = (char*)strWord2; // variable 
	CString wordb = (char*)strWord3; // word for comparison
	CString variable1 = "hsid";
	CString variable2 = "callernum";
	CString variable3 = "callername";
	CString variable4 = "count";

	if ((result = _stricmp(worda, variable1)) == 0) // if $hsid
	{
		if (csMyHandsetId == wordb)
		{	return 0;	}  // execute commands in IF / ENDIF
	}
	else if ((result = _stricmp(worda, variable2)) == 0) // if $senderid
	{
		if ( strCid1 == wordb) // strCid1 is Caller ID number
		{	return 0;	}  // execute commands in IF / ENDIF
	}
	else if ((result = _stricmp(worda, variable3)) == 0) // if $sendername
	{
		if (strCid2 == wordb)  // strCid2 is Caller ID name
		{	return 0;	}  // execute commands in IF / ENDIF
	}
	else if ((result = _stricmp(worda, variable4)) == 0) // if $count
	{
		count++; 
		if ((result = atoi(wordb)) == count)
		{	
			count = 0;    // restart count
			return 0;	  // execute commands in IF / ENDIF
		}
	}
	return 1;  // skip commands in IF / ENDIF
}



// Set all the parameters for this handset thread:
//   iHandsetId: 0 based handset index
//   csScriptFileName: which script are we using
//   iComPortId: which com port are we using
//   iDelay, how long to delay before starting?
//
void ScriptThread::SetInfo( CString csHandsetId, CString csScriptFileName, int iComPortId, int iDelay )
{
	csMyHandsetId = csHandsetId;
	csMyScriptFileName = csScriptFileName;
	iMyComPortId = iComPortId;
	iMyDelay = iDelay;
}

